/*
 * Decompiled with CFR 0.152.
 */
package com.probejs.jdoc.document;

import com.google.gson.JsonObject;
import com.probejs.jdoc.Serde;
import com.probejs.jdoc.document.AbstractDocument;
import com.probejs.jdoc.java.ConstructorInfo;
import com.probejs.jdoc.property.PropertyModify;
import com.probejs.jdoc.property.PropertyParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentConstructor
extends AbstractDocument<DocumentConstructor> {
    private final List<PropertyParam> params = new ArrayList<PropertyParam>();

    public DocumentConstructor() {
    }

    public DocumentConstructor(List<PropertyParam> params) {
        this.params.addAll(params);
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = super.serialize();
        Serde.serializeCollection(object, "params", this.params);
        return object;
    }

    @Override
    public void deserialize(JsonObject object) {
        super.deserialize(object);
        Serde.deserializeDocuments(this.params, object.get("params"));
    }

    @Override
    public DocumentConstructor applyProperties() {
        DocumentConstructor copy = this.copy();
        copy.findPropertiesOf(PropertyModify.class).forEach(modify -> {
            PropertyParam param = copy.params.get(modify.getOrdinal());
            copy.params.set(modify.getOrdinal(), new PropertyParam(modify.getName() != null ? modify.getName() : param.getName(), modify.getNewType() != null ? modify.getNewType() : param.getType(), param.isVarArg()));
        });
        return copy;
    }

    @Override
    public DocumentConstructor copy() {
        return new DocumentConstructor(this.params);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentConstructor that = (DocumentConstructor)o;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return Objects.hash(this.params);
    }

    public List<PropertyParam> getParams() {
        return this.params;
    }

    public static DocumentConstructor fromJava(ConstructorInfo info) {
        DocumentConstructor document = new DocumentConstructor();
        info.getParams().stream().map(PropertyParam::fromJava).forEach(document.params::add);
        return document;
    }
}

